<%@ Control Language="c#" AutoEventWireup="false" Codebehind="ListTemplates.ascx.cs" Inherits="Mediachase.UI.Web.Admin.Modules.ListTemplates" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="BlockHeader" src="..\..\Modules\BlockHeader.ascx" %>
<TABLE class="ibn-stylebox2" cellSpacing="0" cellPadding="0" width="100%" border="0">
	<TR>
		<td><ibn:blockheader id="secHeader" runat="server" /></td>
	</TR>
	<TR>
		<td class="ibn-alternating ibn-navline text" style="padding:7px;">
			<span style="width:20px"><img width="16" height="16" border="0" src="../Layouts/Images/quicktip.gif"></span><%=LocRM.GetString("tListTempText")%>
		</td>
	</tr>
	<tr>
		<td vAlign="top">
			<asp:datagrid id="dgListTemplates" Width="100%" borderwidth="0px" CellSpacing="0" gridlines="None"
				cellpadding="3" AllowSorting=True AllowPaging="False" AutoGenerateColumns="False" Runat="server">
				<ItemStyle Height="28"></ItemStyle>
				<HeaderStyle Height="23"></HeaderStyle>
				<Columns>
					<asp:BoundColumn Visible="False" DataField="TemplateId"></asp:BoundColumn>
					<asp:TemplateColumn SortExpression="Title">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<a href='../Lists/ListInfo.aspx?TemplateId=<%# DataBinder.Eval(Container.DataItem, "TemplateId")%>'>
							<%# DataBinder.Eval(Container.DataItem, "Title")%>
							</a>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:TextBox ID="txtTitle" Width="90%" Runat=server CssClass="text" Text='<%# DataBinder.Eval(Container.DataItem, "Title")%>'></asp:TextBox>
							<asp:RequiredFieldValidator ID="rfText" ControlToValidate="txtTitle" Runat=server CssClass="text" ErrorMessage="*" Display=Dynamic></asp:RequiredFieldValidator>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem, "Description")%>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:TextBox ID="txtDescr" Width="95%" TextMode=MultiLine Rows="5" Runat=server CssClass="text" Text='<%# DataBinder.Eval(Container.DataItem, "Description")%>'></asp:TextBox>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="sortCreatorName">
						<HeaderStyle CssClass="ibn-vh2" Width="160px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem, "CreatorName")%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="Created">
						<HeaderStyle CssClass="ibn-vh2" Width="120px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# ((DateTime)DataBinder.Eval(Container.DataItem, "Created")).ToShortDateString()%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem, "MetaFields")%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle Width="54px" CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<asp:imagebutton id="ibEdit" runat="server" borderwidth="0" width="16" height="16" title='<%# LocRM.GetString("Edit")%>' imageurl="../../layouts/images/edit.GIF" commandname="Edit" causesvalidation="False">
							</asp:imagebutton>&nbsp;
							<asp:imagebutton id="ibDelete" runat="server" borderwidth="0" width="16" height="16" title='<%# LocRM.GetString("Delete")%>' imageurl="../../layouts/images/DELETE.GIF" commandname="Delete" causesvalidation="False">
							</asp:imagebutton>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:imagebutton id="ibSave" runat="server" borderwidth="0" width="16" height="16" title='<%# LocRM.GetString("Save")%>' imageurl="../../layouts/images/saveitem.GIF" commandname="Update">
							</asp:imagebutton>&nbsp;
							<asp:imagebutton id="ibCancel" runat="server" borderwidth="0" width="16" height="16" title='<%# LocRM.GetString("Cancel")%>' imageurl="../../layouts/images/cancel.GIF" commandname="Cancel" causesvalidation="False">
							</asp:imagebutton>
						</EditItemTemplate>
					</asp:TemplateColumn>
				</Columns>
			</asp:datagrid>
		</td>
	</tr>
</table>